WITH
"analytics::users" AS (
SELECT id, name, email, created_at FROM users
),
"analytics::orders" AS (
SELECT id, user_id, total, created_at FROM orders
),
_n001 AS (
SELECT *
FROM "analytics::users" AS left
INNER JOIN "analytics::orders" AS right ON (users.id = orders.user_id)
),
_n002 AS (
SELECT users.name, COUNT(orders.id) AS total_orders, SUM(orders.total) AS total_spent
FROM _n001
GROUP BY users.name
),
_n003 AS (
SELECT *
FROM _n002
ORDER BY total_spent
),
_n004 AS (
SELECT *
FROM _n003
LIMIT 10
)
SELECT name, total_orders, total_spent
FROM _n004