# deet golden demo

This demo shows the end-to-end workflow: contract -> check -> compile -> export.

## 1) Install the CLI

```bash
npm install -g @deet/compiler
```

## 2) Typecheck

```bash
deet check
```

## 3) Export contracts

```bash
deet contract
```

Artifacts:
- `contracts/user_analytics.d.ts`

## 4) Compile SQL

```bash
deet compile --target duckdb --out dist
```

Artifacts:
- `dist/graph.rxg.json`
- `dist/sql/analytics::user_analytics.sql`

## 5) Load data + run SQL

```bash
duckdb dev.duckdb < scripts/load_duckdb.sql
```

## What to inspect

- `src/analytics.dt` - typed pipeline
- `contracts/user_analytics.d.ts` - typed contract output (TypeScript-style)
- `dist/lineage.mmd` - lineage graph (Mermaid)
- `.github/workflows/deet.yml` - CI example
